#version 330
#extension GL_EXT_gpu_shader4 : enable
//Wavefunctions reduxMod01.fsh by  djmkultra
//https://www.shadertoy.com/view/ltsXD7
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define HEIGHT_FIELD 1  // Render Fxy (2D function as a height field), otherwise Fxyz volume rendering
#define COMPONENTS 0  // Toggle between real/im components and magnitude vis.

const int kMarchSteps = 111; // Adjust this value for better quality or faster rendering.

const float near = 1.;
const float zoom = .002;
const vec3 kEye = vec3(5., 10., 10.) * 2.;
vec3 eye = kEye;
vec3 at = vec3(0., 0., 0.);

const vec4 backgroundColor = vec4(0.);
const float brightness = 2.;

const float pi = 3.14159265359;
const float twopi = 2. * pi;

vec4 rands = vec4(0.);

vec3 Tone(vec3 hdr, float scale, float base) {
    vec3 hdrs = max(hdr, 0.) * scale;
    return hdrs / (vec3(base) + hdrs);
}
vec3 Tone(vec3 hdr) { return Tone(hdr, brightness, 1.); }
vec4 Tone(vec4 hdra) { return vec4(Tone(hdra.rgb), hdra.a); }

vec4 HitXZPlane(vec3 start, vec3 dir) {
    float t = -start.y / dir.y;
    return vec4(start + dir * t, t);
}

vec4 HitXYPlane(vec3 start, vec3 dir) {
    float t = -start.z / dir.z;
    return vec4(start + dir * t, t);
}

// returns xyz pos and t value for the backside of box, neg for no hit
vec4 HitBox(vec3 minp, vec3 maxp, vec3 start, vec3 dir) {
 	vec3 tminp = start - minp;
    vec3 tmaxp = start - maxp;
    vec3 invdir = -vec3(1.) / dir;
    tminp *= invdir;
    tmaxp *= invdir;
    vec3 tmin = min(tminp, tmaxp);
    vec3 tmax = max(tminp, tmaxp);
    float maxt = min(min(tmax.x, tmax.y), tmax.z);
    float mint = max(max(tmin.x, tmin.y), tmin.z);
    return vec4(start + dir * mint, maxt < mint ? -1. : (maxt - mint));
}

vec3 GetRayDir(vec2 uv) {
	vec3 up = vec3(0., 1., 0.);
    vec3 vdir = normalize(at - eye);
    vec3 xdir = normalize(cross(vdir, up));
    up = normalize(cross(xdir, vdir));
    vec3 center = eye + vdir * near;
    vec2 zuv = (uv - vec2(.5)) * iResolution.xy * zoom;
    vec3 pix = center + zuv.x * xdir + zuv.y * up;
    return pix - eye;
}

vec4 GridColor(vec2 uv) {
    const float linewidth = .1;
    //float order = log
    float tickwidth = 10.;
 	vec2 duv = fwidth(uv);
    float fade = clamp(1.1 - max(duv.x, duv.y) / (tickwidth * .6), 0., 1.);
    vec2 duv2 = duv;
    duv *= linewidth;
    duv2 += duv;
    vec2 ticks = smoothstep(duv2, duv, abs(mod(uv + duv2, vec2(tickwidth)) - duv2)) * fade;
    vec2 axis = smoothstep(duv2, duv, abs(uv)) * fade;
    float axisv = max(axis.x, axis.y);
    vec4 color = vec4(.15, .15, .15, 1.) * max(ticks.x, ticks.y) * (1. - axisv)
        + vec4(1., .1, .1, 1.) * axisv;
    return color;
}

vec4 Blend(vec4 bottom, vec4 top) { return bottom * (1. - top.a) + top; }

float ttest(float t) { return step(0., t); }

// E^(i*theta*lambda + phase)
vec2 CExp(float theta, float lambda, float phase) {
 	float v = theta * lambda + phase;
    return vec2(cos(v),sin(v));
}

// ------------------------------------------------------------
// Complex-valued function of x and y that is the super-position of complex waves.

vec2 DemoWaves(float x, float y) {
    float theta = atan(x, y);
 	float d = length(vec2(x,y));
    float t = -iTime;
    
    //------------------
    // This is the place to play with the waves, try altering their direction and phaes etc...
    
    // Radial waves
    vec2 radialwave = 1. * CExp(d, 1., t);
    radialwave += CExp(d, 2., t * 1.01) * rands.x;
    radialwave += CExp(-d, 3., t * 1.005) * rands.y;
    
    // Angular waves
    vec2 angularwave = CExp(theta, 2., t * 1.07) * rands.z;
    angularwave += CExp(-theta, 5., -t) * rands.w;
    
    return 1. * radialwave + 1. * angularwave;
}

vec2 CxyWaves(float x, float y) {
    return DemoWaves(x, y);
}

// crappy complex coloring: Real = (red-green), Imaginary = (yellow-blue)
vec4 CColor(vec2 c, vec2 weight) {  
    const vec4 rcolor = vec4(1., 0.01, 0.01, 1.);
    const vec4 rcolorn = vec4(0., 1., 0.01, 1.);
    const vec4 icolor = vec4(.9, .9, 0.01, 1.);
    const vec4 icolorn = vec4(0.01, 0.01, 1., 1.);
	vec4 realcolor = (rcolor* max(c.x, 0.) + (rcolorn) * max(-c.x, 0.));
    realcolor.a = 1.;
    vec4 imagcolor = (icolor * max(c.y, 0.) + (icolorn) * max(-c.y, 0.));
    imagcolor.a = 1.;
 	vec4 color = (realcolor * weight.x + imagcolor * weight.y);
    return color;
}

// ----------------------------------------------------
// Height field evaluation for a (complex-valued) function of two variables
vec4 prevval = vec4(0.);  // used to detect isosurface crossing.
vec4 Fxy(vec3 xyz) {
	const float thickness = 1.;
    
	// Evaluate the function.
 	vec2 val = CxyWaves(xyz.x, xyz.z) * vec2(1., 1.);
    
    // Compute color.
#if COMPONENTS
    // Visualize real and imaginary parts as 2 height fields
    vec2 dif = val - xyz.yy;
    vec2 crossing = prevval.xy * dif;
    vec2 stepwidth = prevval.xy - dif;
    vec4 w = abs(vec4(prevval.xy, dif) / stepwidth.xyxy);
    //w = vec4(1., 1., 0., 0.);
    crossing = step(0.00000001, -crossing);
    vec4 color = CColor(val * w.xy + prevval.zw * w.zw, crossing * .5) * .8;
    prevval = vec4(dif, val);
#else
    // Visualize the amplitude of the wave function.
    float d = length(val) - xyz.y;
    float crossing = (prevval.z * d) < 0. ? 1. : 0.;
    vec2 w = abs(vec2(prevval.z, d) / (prevval.z - d));
	vec4 color = CColor(val * w.x + prevval.xy * w.y, vec2(.5));
    prevval.xyz = vec3(val, d);
    color = color * crossing * .8;    
#endif
    
    return color;
}

// ------------------------------------------------
// A funtion of x, y, z, returns color. Volume-render 3D function.

vec4 Fxyz(vec3 xyz) {
    const float scale = 5.;
    const float d = 1.;
    float dist = length(xyz);
    float amp = 1. / (1. + dist * dist);
	float wave = sin(dist * scale + iTime);
    vec4 c = max(0., wave) * vec4(1., .1, .1, 1.) + max(0., -wave) * vec4(.1, .1, 1., 1.);
 	return  vec4(c.rgb, 1.) * amp;  
}


vec4 March(vec3 start, vec3 dir, float maxd, float dd) {
    vec4 ddir = vec4(dir, 1.) * dd;
    vec4 pos = vec4(start, 0.);
    vec4 color = vec4(0.);
    prevval = vec4(-pos.y);
    for (int i = 0; i < kMarchSteps; ++i) {
        float density = 1.;
        
#if HEIGHT_FIELD
        // 2D height field.
        vec4 c = Fxy(pos.xyz);
#else 
        // 3D function volume rendering
        vec4 c = Fxyz(pos.xyz);
#endif        
        
        // axis clipping
        //c = pos.z > 0. ? vec4(0.) : c; 
        
        c = (pos.w > maxd ? vec4(0.) : c); // reject samples outside box
        c.a = clamp(c.a, 0., 1.);  // insure we have good alpha values.
        color = color + c * (1. - color.a);  // blending
        pos += ddir;
    }
    return color;
}

// key is javascript keycode: http://www.webonweboff.com/tips/js/event_key_codes.aspx
bool ReadKey( int key, bool toggle )
{
	float keyVal = texture( iChannel1, vec2( (float(key)+.5)/256.0, toggle?.75:.25 ) ).x;
	return (keyVal>.5)?true:false;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    bool one = ReadKey( 49, true );
    bool two = ReadKey( 50, true );
    bool three = ReadKey( 51, true );

    float theta = iMouse.x / iResolution.x * twopi;
    if (one) {  // 1 key toggles orbit
        theta += iTime * .2;
    }
    vec2 cossin = vec2(cos(theta), sin(theta));
    eye.x = kEye.x * cossin.x - kEye.z * cossin.y;
    eye.z = kEye.x * cossin.y + kEye.z * cossin.x;

    eye.y -= (iMouse.y > 0. ? 1. : 0.) * (iMouse.y - iResolution.y * .5) * .3;
    
	vec2 uv = gl_FragCoord.xy / iResolution.xy;
    	
    rands = vec4(.5) + .5 * cos(vec4(iTime) * vec4(1., -.997, 1.13, 1.21) * .5 + vec4(13., 17., 19., 23.));
	// 2 key toggles random coefficients.
    rands = two ? vec4(1.) : rands;
	rands = smoothstep(.3, .6, rands);
    
    vec3 ray = GetRayDir(uv);
    float rayd = length(ray);
    float invrayd = 1. / rayd;

#if 1
    // jittering expariment, .
    vec4 noise = texture(iChannel0, uv / fwidth(uv) / 255.);
    vec3 jitterStart = ray * invrayd * (.5 - noise.x) * 2.;
    //jitterStart = mix(vec3(0.), jitterStart, (1. + sin(iTime)) * .5);
#else
    vec3 jitterStart = vec3(0.);     
#endif
    
    // Domain grid. (not yet integrated with the sceen correctly)
    vec4 xzplane = HitXZPlane(eye, ray);
    vec4 xzgrid = GridColor(xzplane.xz) * ttest(xzplane.w);
    vec4 xyplane = HitXYPlane(eye, ray);
    vec4 xygrid = GridColor(xyplane.xy) * ttest(xyplane.w);
    vec4 gridcolor = Blend(xzgrid * .5, xygrid * .1);
    
    // Set up the function domain.
    float boxscale = 5.;
    vec3 boxsize = vec3(3., 1., 3.) * boxscale;
    vec4 boxhit = HitBox(-boxsize, boxsize, eye, ray);
    
    // Set up step size and stopping distance
    float backlen = boxhit.w * rayd; 
   	float dr =  backlen / float(kMarchSteps); //sqrt(2.) * 2. * boxscale / float(kMarchSteps);
    
    // March!
    vec4 marchColor = March(boxhit.xyz + jitterStart * dr, ray * invrayd, backlen, dr) * ttest(boxhit.w);

    gl_FragColor = vec4(Blend(backgroundColor, Blend(gridcolor * 1., Tone(marchColor))));
}